<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Category extends Model 
{

    protected $table = 'categories';
    public $timestamps = true;
    protected $fillable = array('status');

    public function User()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function Steps()
    {
        return $this->hasMany('App\Models\Step');
    }

    public function Icon()
    {
        return $this->hasOne('App\Models\Icon');
    }

    public function Tickets()
    {
        return $this->hasMany('App\Models\Ticket');
    }

}